#pragma once
#include "ftpclient.h"
#include "xmlreader.h"

class COptions;

struct OpenFileDef {
	wstring FTPFile;
	wstring TempFile;
};

class ConnHand
{
public:
	ConnHand(void);
	~ConnHand(void);

	int fileno;
	nsFTP::CFTPClient m_FTPClient;
	nsFTP::CLogonInfo m_LogonInfo;
	COptions* opt;

	nsFTP::TStringVector existFiles;
	wstring existPath;

	map <FILE *,OpenFileDef> OpenFiles;

	bool ValidateConn(COptions * in_opt);
	XMLReader* LoadConfigFile(wstring configfile, wstring path = L"");
	errno_t WriteFile(FILE ** fp,wstring Filename);
	void CloseFile(FILE * fp);
	wstring GetTempFile(wstring ext = L"");
	int _FileExists(wstring filename);
	void Mkdir(wstring dir);
	wstring DownloadFile(wstring file);
	void DeleteFile(wstring file);
	bool UplodaFile(wstring source, wstring dest);
};
